/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.binarysearch;

import com.mycompany.binarysearch.BST;
import com.mycompany.binarysearch.NodeBST;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class main {
    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);
        if (args.length < 2) {
            System.out.println("Usage: java Main <operation> <keyword>");
            System.out.println("<operation> 0 for search, 1 for remove");
            return;
        }
        int operation = Integer.parseInt(args[1]);
        String titleKeyword = args[2];
        BST bst = new BST();
        System.out.print("DataSet File: ");
        String csvFile = in.next();
        long startTime = System.currentTimeMillis();
        System.out.println("Start time: " + startTime);
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            System.out.println("Started reading dataset file");
            while ((line = br.readLine()) != null) {
                String[] data = line.split(",");
                if (data[0].equals("Job ID")) continue;
                int jobId = Integer.parseInt(data[0]);
                String title = data[1];
                String company = data[2];
                String datePosted = data[3];
                String companyIndustry = data[4];
                String jobRole = data[5];
                String degree = data[6];
                String jobCity = data[7];
                int maxAge = main.isNumeric(data[8]) ? Integer.parseInt(data[8]) : 0;
                int monthlySalaryMaxRange = main.isNumeric(data[9]) ? Integer.parseInt(data[9]) : 0;
                NodeBST node = new NodeBST(jobId, title, company, datePosted, companyIndustry, jobRole, degree, jobCity, maxAge, monthlySalaryMaxRange);
                bst.insert(node);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long fileReadEndTime = System.currentTimeMillis();
        System.out.println("Loaded file in BST");
        System.out.println("End time: " + fileReadEndTime);
        System.out.println("Time taken: " + (double)(fileReadEndTime - startTime) / 1000.0 + " milliseconds");
        long operationStartTime = System.currentTimeMillis();
        System.out.println("\nStart time: " + operationStartTime);
        System.out.println("Operation keyword: " + titleKeyword);
        if (operation == 0) {
            NodeBST result = bst.search(titleKeyword);
            long operationEndTime = System.currentTimeMillis();
            System.out.println("End time: " + operationEndTime);
            System.out.println("Time taken: " + (double)(operationEndTime - operationStartTime) / 1000.0 + " milliseconds");
            if (result != null) {
                System.out.println("\nFound: " + String.valueOf(result));
            } else {
                System.out.println("\nNo job found with title: " + titleKeyword);
            }
        } else if (operation == 1) {
            bst.remove(titleKeyword);
            long operationEndTime = System.currentTimeMillis();
            System.out.println("End time: " + operationEndTime);
            System.out.println("Time taken: " + (double)(operationEndTime - operationStartTime) / 1000.0 + " milliseconds");
            System.out.println("\nJob with title '" + titleKeyword + "' removed from the BST.");
        } else {
            System.out.println("Invalid operation choice. Please enter 0 for search or 1 for remove.");
        }
    }

    private static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

