/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.binarysearch;

import com.mycompany.binarysearch.NodeBST;

class BST {
    private NodeBST root = null;

    public void insert(NodeBST node) {
        this.root = this.insertRec(this.root, node);
    }

    private NodeBST insertRec(NodeBST current, NodeBST node) {
        if (current == null) {
            return node;
        }
        if (node.title.compareTo(current.title) < 0) {
            current.left = this.insertRec(current.left, node);
        } else if (node.title.compareTo(current.title) > 0) {
            current.right = this.insertRec(current.right, node);
        }
        return current;
    }

    public NodeBST search(String title) {
        return this.searchRec(this.root, title);
    }

    private NodeBST searchRec(NodeBST current, String title) {
        if (current == null || current.title.equals(title)) {
            return current;
        }
        if (title.compareTo(current.title) < 0) {
            return this.searchRec(current.left, title);
        }
        return this.searchRec(current.right, title);
    }

    public void remove(String title) {
        this.root = this.removeRec(this.root, title);
    }

    private NodeBST removeRec(NodeBST current, String title) {
        if (current == null) {
            return null;
        }
        if (title.equals(current.title)) {
            if (current.left == null) {
                return current.right;
            }
            if (current.right == null) {
                return current.left;
            }
            current.title = this.minValue(current.right);
            current.right = this.removeRec(current.right, current.title);
        } else if (title.compareTo(current.title) < 0) {
            current.left = this.removeRec(current.left, title);
        } else {
            current.right = this.removeRec(current.right, title);
        }
        return current;
    }

    private String minValue(NodeBST root) {
        String minv = root.title;
        while (root.left != null) {
            minv = root.left.title;
            root = root.left;
        }
        return minv;
    }
}

